import { createVNode as _createVNode } from "vue";
// Styles
import "./VDataTableFooter.css";

// Components
import { VBtn } from "../../components/VBtn/index.mjs";
import { VSelect } from "../../components/VSelect/index.mjs"; // Composables
import { usePagination } from "./composables/paginate.mjs";
import { useLocale } from "../../composables/locale.mjs"; // Utilities
import { computed } from 'vue';
import { genericComponent, propsFactory } from "../../util/index.mjs"; // Types
export const makeVDataTableFooterProps = propsFactory({
  prevIcon: {
    type: String,
    default: '$prev'
  },
  nextIcon: {
    type: String,
    default: '$next'
  },
  firstIcon: {
    type: String,
    default: '$first'
  },
  lastIcon: {
    type: String,
    default: '$last'
  },
  itemsPerPageText: {
    type: String,
    default: '$vuetify.dataFooter.itemsPerPageText'
  },
  pageText: {
    type: String,
    default: '$vuetify.dataFooter.pageText'
  },
  firstPageLabel: {
    type: String,
    default: '$vuetify.dataFooter.firstPage'
  },
  prevPageLabel: {
    type: String,
    default: '$vuetify.dataFooter.prevPage'
  },
  nextPageLabel: {
    type: String,
    default: '$vuetify.dataFooter.nextPage'
  },
  lastPageLabel: {
    type: String,
    default: '$vuetify.dataFooter.lastPage'
  },
  itemsPerPageOptions: {
    type: Array,
    default: () => [{
      value: 10,
      title: '10'
    }, {
      value: 25,
      title: '25'
    }, {
      value: 50,
      title: '50'
    }, {
      value: 100,
      title: '100'
    }, {
      value: -1,
      title: '$vuetify.dataFooter.itemsPerPageAll'
    }]
  },
  showCurrentPage: Boolean
}, 'VDataTableFooter');
export const VDataTableFooter = genericComponent()({
  name: 'VDataTableFooter',
  props: makeVDataTableFooterProps(),
  setup(props, _ref) {
    let {
      slots
    } = _ref;
    const {
      t
    } = useLocale();
    const {
      page,
      pageCount,
      startIndex,
      stopIndex,
      itemsLength,
      itemsPerPage,
      setItemsPerPage
    } = usePagination();
    const itemsPerPageOptions = computed(() => props.itemsPerPageOptions.map(option => ({
      ...option,
      title: t(option.title)
    })));
    return () => _createVNode("div", {
      "class": "v-data-table-footer"
    }, [slots.prepend?.(), _createVNode("div", {
      "class": "v-data-table-footer__items-per-page"
    }, [_createVNode("span", null, [t(props.itemsPerPageText)]), _createVNode(VSelect, {
      "items": itemsPerPageOptions.value,
      "modelValue": itemsPerPage.value,
      "onUpdate:modelValue": v => setItemsPerPage(Number(v)),
      "density": "compact",
      "variant": "outlined",
      "hide-details": true
    }, null)]), _createVNode("div", {
      "class": "v-data-table-footer__info"
    }, [_createVNode("div", null, [t(props.pageText, !itemsLength.value ? 0 : startIndex.value + 1, stopIndex.value, itemsLength.value)])]), _createVNode("div", {
      "class": "v-data-table-footer__pagination"
    }, [_createVNode(VBtn, {
      "icon": props.firstIcon,
      "variant": "plain",
      "onClick": () => page.value = 1,
      "disabled": page.value === 1,
      "aria-label": t(props.firstPageLabel)
    }, null), _createVNode(VBtn, {
      "icon": props.prevIcon,
      "variant": "plain",
      "onClick": () => page.value = Math.max(1, page.value - 1),
      "disabled": page.value === 1,
      "aria-label": t(props.prevPageLabel)
    }, null), props.showCurrentPage && _createVNode("span", {
      "key": "page",
      "class": "v-data-table-footer__page"
    }, [page.value]), _createVNode(VBtn, {
      "icon": props.nextIcon,
      "variant": "plain",
      "onClick": () => page.value = Math.min(pageCount.value, page.value + 1),
      "disabled": page.value === pageCount.value,
      "aria-label": t(props.nextPageLabel)
    }, null), _createVNode(VBtn, {
      "icon": props.lastIcon,
      "variant": "plain",
      "onClick": () => page.value = pageCount.value,
      "disabled": page.value === pageCount.value,
      "aria-label": t(props.lastPageLabel)
    }, null)])]);
  }
});
//# sourceMappingURL=VDataTableFooter.mjs.map