<?php
  
use App\Http\Controllers\CheckDatas\DayCheckController;
use App\Http\Controllers\Boulangerie\CommandeController;
use App\Http\Controllers\egpv2\compta\ComptaDet;
use App\Http\Controllers\egpv2\configEts\NavBarController;
use App\Http\Controllers\ExportsClients\ExportDispatch;
use App\Http\Controllers\ExportsClients\ExportDispatchv2;
use App\Http\Controllers\ImportsClients\ImportDispatch;
use App\Http\Controllers\InterfacesApi\numeria\BaseCall;
use App\Http\Controllers\InterfacesApi\numeria\GetDoc;
use App\Http\Controllers\InterfacesApi\numeria\SendDoc;
use App\Http\Controllers\InterfacesApi\numeria\StatusAll;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\OutilsBdd\NdossiersAllTables;
use App\Http\Controllers\TaskController;
use App\Http\Controllers\Tickets\TicketsController;
use App\Http\Controllers\NewClientsCreation\SqueletteController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Hotfixs\HotfixsController;
use App\Http\Controllers\InterfacesApi\webfleet\ImportKms;
use App\Http\Controllers\NewClientsCreation\ImportFromFec;
use App\Http\Controllers\pluginsEgp\ArchivageCompta\ArchivageComptaController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/
//egpV2
// Route::get('/egpv2/interrocptetiers/{n_dossier}/{n_exercice}/{orderBy}', [ComptaDet::class, 'index']);
// Route::get('/egpv2/navbar', [NavBarController::class, 'index']);

//LocalTest



Route::post('/login', [LoginController::class, 'authenticate'])->name('login');

Route::middleware(['clientsexterne'])->group(function () {
    Route::get('/testImport', [ImportKms::class, 'webfleetImportKms']);
});

//AUTH client externe
Route::middleware(['clientsexterne'])->group(function () {
    //EXPORTS CLIENTS
    Route::get('/{database}/exports/{table}/{n_dossier}/{n_ex}', [ExportDispatch::class, 'exportDispatch']);
    Route::get('/{database}/exportsplus/{table}/{n_dossier}/{n_ex}', [ExportDispatch::class, 'exportDispatchEtDet']);
    Route::get('/{database}/exportsrh/{table}/{n_dossier}/{n_ex}', [ExportDispatch::class, 'exportDispatchRh']);
    Route::get('/{database}/daily/exports/{table}/{n_dossier}/{n_ex}', [ExportDispatchv2::class, 'exportDispatch']);
    Route::get('/{database}/daily/exportsplus/{table}/{n_dossier}/{n_ex}', [ExportDispatchv2::class, 'exportDispatchMateriel']);
    Route::get('/{database}/daily/exportsrh/{table}/{n_dossier}/{n_ex}', [ExportDispatchv2::class, 'exportDispatchRh']);
});

//AUth sanctum

Route::middleware(['auth:sanctum'])->group(function () {
    // SUPPORT
    Route::post('/support/login', [TicketsController::class, 'login']);
    Route::get('/support/ticketsall', [TicketsController::class, 'getTicketsAll']);
    Route::get('/support/ticketsNA', [TicketsController::class, 'getTickets']);
    Route::get('/support/ticketsHome/{name}', [TicketsController::class, 'getTicketsHome']);
    Route::get('/support/ticket/{database}/{id}', [TicketsController::class, 'getTicket']);
    Route::get('/support/Ndossiertest/{N_DOSSIER_OLD}/{N_DOSSIER_NEW}', [NdossiersAllTables::class, 'changeAllNdossierAllBdds']);
    Route::post('support/sendNotif/{db}/{id}', [TicketsController::class, 'sendNotifEscalade']);
    Route::get('support/sendMail/{db}/{id}', [TicketsController::class, 'sendMailDateEch']);
    Route::post('/support/ticket/{database}/{id}/{id_det}/addDocToTicket', [TicketsController::class, 'addDocToTicket']);
    Route::post('/support/ticket/{database}/{id}/deleteDoc', [TicketsController::class, 'delDocToTicket']);
    Route::post('/support/ticket/{database}/{id}', [TicketsController::class, 'postTicket']);
    Route::post('/support/ticketDet/{database}/{id}', [TicketsController::class, 'postTicketDet']);
    Route::post('/support/ticketDetCloture/{database}/{id}', [TicketsController::class, 'postTicketDetCloture']);
    Route::get('/support/ticketDetReouverture/{database}/{id}', [TicketsController::class, 'postTicketDetReouverture']);
    Route::get('support/sendNotifNewOrRep/{db}/{id}', [TicketsController::class, 'sendNotifNewOrReponse']);

    //NEW CLIENT
    Route::post('/support/CreateNewDb', [SqueletteController::class, 'configDb']);
    Route::post('/support/CreateNewDossier', [SqueletteController::class, 'createDossierSolo']);
    Route::post('/support/addDocToImport', [SqueletteController::class, 'AddDocToImport']);
    Route::post('/support/saveConfig',[SqueletteController::class, 'saveConfig']);
    Route::post('/support/importFec', [ImportFromFec::class, 'index']);
    Route::post('/support/addDocToFec', [ImportFromFec::class, 'AddDoc']);
    Route::get('/support/importDatasfromClients/{nomSimple}', [SqueletteController::class, 'importDatasfromClients']);
    Route::get('/support/listDir', [SqueletteController::class, 'listDir']);
    Route::get('/support/linktiers/{nomSimple}', [SqueletteController::class, 'linkTiers']);
    Route::get('/support/linkdossier/{nomSimple}', [SqueletteController::class, 'linkDossiers']);
    Route::get('/support/createinfoscompta/{nomSimple}', [SqueletteController::class, 'creationTiersInfoCompta']);
    Route::get('/support/logsimports', [SqueletteController::class, 'showLog']);
    Route::get('/support/getConfigs',[SqueletteController::class, 'getConfigs']);
    Route::get('/support/linkFec/{nomSimple}',[ImportFromFec::class, 'linkFec']);
    Route::get('/support/linkFec2/{nomSimple}',[ImportFromFec::class, 'linkFec2']);

    // Route::get('/support/resetAll', [SqueletteController::class, 'showLog']);
    Route::resource('/support/tasks', TaskController::class);
});

//Uprotected routes


// BOULANGERIE
Route::post('/{db}/commande/postCommande', [CommandeController::class, 'AddCommande']);
Route::post('/{db}/commande/UpdateCommande', [CommandeController::class, 'UpdateCommande']);
Route::post('/{db}/commande/deleteDet/{id}', [CommandeController::class, 'DeleteDet']);
Route::post('/{db}/commande/deleteEt/{id}', [CommandeController::class, 'DeleteEt']);
Route::get('/{db}/commande/articles', [CommandeController::class, 'getArticles']);
Route::get('/{db}/commande/articlesAll', [CommandeController::class, 'getArticlesAll']);
Route::get('/{db}/commande/messagePersoComm', [CommandeController::class, 'GetMessageManuel']);
Route::get('/{db}/commande/messagePersoRecap', [CommandeController::class, 'GetMessageRecap']);
Route::get('/{db}/commande/pLivraison', [CommandeController::class, 'getPointsLivraison']);
Route::get('/{db}/commande/GetCommande/{id}', [CommandeController::class, 'GetCommande']);
Route::post('/{db}/commande/getDateAbo', [CommandeController::class, 'getDateAbo']);
Route::post('/{db}/commande/createAbo', [CommandeController::class, 'CreateAbonnement']);
Route::get('/{db}/commande/getDisabledDates', [CommandeController::class, 'getDisabledDates']);

//hotfixes
// Route::get('/repacoloc/{db}', [HotfixsController::class, 'AddMaterielDet'] );


//alertes  /  Etat
// Route::get('/support/all/etatBases', [DayCheckController::class, 'getVerif']);

//INTERFACE API OMP
// Route::get('/InterfaceApiOmp/ImportKms', [OmpImportKms::class, 'OmpImportKmsExe'] );

//UTILS
// Route::get('/utils/getExchangeRate', [ExchangeRate::class, 'getExchangeRate'] );
// Route::middleware(['EGP'])->group(function () {
//    PLUGINS EGP
Route::get('/sendDoc/{db}', [SendDoc::class, 'sendDocAll'] );
Route::get('/sendDocSolo/{db}/{id}', [SendDoc::class, 'sendDocSolo'] );
Route::get('/getDoc/{db}', [GetDoc::class, 'getDocAll'] );
Route::get('/getDocSolo/{db}/{id}', [GetDoc::class, 'getDocSolo'] );
Route::get('/statusAll/{db}', [StatusAll::class, 'MajStatusAll'] );

// pour archivage exercice comptabilite
Route::get('/archiveCompta/{database}/{n_dossier}/{n_exercice}', function($database, $n_dossier, $n_exercice) {
    dispatch(new \App\Jobs\ArchiveCompta($database, $n_dossier, $n_exercice));
    Echo('Le traitement est lanc�.');
});
Route::get('/archiveComptaVerif/{database}/{n_dossier}/{n_exercice}', [ArchivageComptaController::class, 'verifComptaArchive'] );

//IMPORTS CLIENTS
Route::post('/{database}/imports/kms', [ImportDispatch::class, 'importDispatch']);
Route::get('/imports/transicsKms', [ImportDispatch::class, 'importDispatchTransics']);
//DOCS
