<?php

namespace App\Services\S3P;


class S3pApiWrapper
{

    protected $api = null;
    protected $token = null;

    /* ----- CONSTRUCTION ----- */

    public function __construct()
    {

        $this->token = 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJzM3B3ZWIiLCJzdWIiOiI2NjM0YjAwYzE5NDE1NzAwMTk3MzkxNWYiLCJmaXJzdE5hbWUiOiJBUEkiLCJsYXN0TmFtZSI6IkVHTE9CQUwiLCJlbnRpdHlJZCI6IjY1ZWVjNDQxMWNkNTMyMDAxOTZiZWY5OCIsImVtYWlsIjoiYXBpLXBkbC5lZ2xvYmFsQHMzcHdlYi5jb20iLCJyb2xlcyI6WyJzM3BfcGx1c19hZG1pbiJdLCJkYXRlRXhwaXJhdGlvbiI6IjIwMzQtMDUtMDNUMDI6MDA6MDAuMDAwWiIsInRva2VuIjoiWlFWUVBaa0dybks1bUh1SklmUDVqYW5wUlFldHUxUWQiLCJsb2NhbGUiOiJmciIsImlhdCI6MTcxNDcyODk4NiwiZXhwIjozMTcyMjAxNDI1NDR9.FSm6AQ7Abo9Ljn5U3_YCT6aT8YM8ehtXLakhLE35bx0';
        $this->api = "https://tracking-api-beta.s3pweb.io/api";
        $this->message = array();

    }


    /* ----- API GET METHOD ------ */

    public function api_get_method($ref, $args)
    {
        $url = $this->api . $ref . '?';
        $url_args = '';

        foreach ($args as $key => $val) {
            $url_args .= $key . '=' . $val . '&';
        }
        $url .= $url_args;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        $authorization = "Authorization: Bearer " . $this->token;
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json', $authorization));

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_COOKIESESSION, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");

        $result = curl_exec($ch);

        $this->message = array();
        $this->add_response($result);
        curl_close($ch);
    }


    /* ----- API POSTMETHOD ------ */

    public function api_post_method($ref, $args)
    {
        $url = $this->api . $ref;

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        $authorization = "Authorization: Bearer " . $this->token;
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json', $authorization));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_COOKIESESSION, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");

        $query = http_build_query($args);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $query);

        $result = curl_exec($ch);

        $this->message = array();
        $this->add_response($result);
        curl_close($ch);
    }


    /* ----- API CUSTOM METHOD ------ */

    public function api_custom_method($ref, $type)
    {
        $url = $this->api . $ref;

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        $authorization = "Authorization: Bearer " . $this->token;
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json', $authorization));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_COOKIESESSION, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $type);

        $result = curl_exec($ch);

        $this->message = array();
        $this->add_response($result);
        // $this->add_message('url ',$ref);
        curl_close($ch);
    }


    /* ----- API PUT METHOD ------ */

    public function api_put_method($ref, $id)
    {
        $this->api_custom_method($ref . '/' . $id, 'PUT');
    }


    /* ----- API DELETE METHOD ------ */

    public function api_delete_method($ref, $id)
    {
        $this->api_custom_method($ref . '/' . $id, 'DELETE');
    }


    /* ----- API PATCH METHOD ------ */

    public function api_patch_method($ref, $id, $args)
    {
        $url = $ref . '/' . $id . '?';
        $url_args = '';
        foreach ($args as $key => $val) {
            if ($key == 'message' || $key == 'html' || $key == 'name' || $key == 'subject' || $key == 'description' || $key == 'short_description') {
                $val_encode = urlencode($val);
            } else {
                $val_encode = $val;
            }
            $url_args .= $key . '=' . $val_encode . '&';
        }
        $url .= $url_args;
        $this->api_custom_method($url, 'PATCH');
    }



    /**
     * MAPPING function API
     */

    /* /api/ressources */
    public function getRessources(): array
    {

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $this->api . '/resources?fast=false');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

        $headers = [
            'Accept: */*',
            'Authorization: Bearer ' . $this->token,
        ];
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error: ' . curl_error($ch);
        }
        curl_close($ch);

        $result2 = json_decode($result, true);

        // Filtrage des résultats pour conserver uniquement les véhicules actifs
        $resultsFiltered = collect($result2)
            ->where('type', 'vehicle')
            ->where('active', true)
            ->toArray();

        $response = [];
        foreach ($resultsFiltered as $res) {
//
            if (
                isset($res['input'][0]['active']) &&
                isset($res['input'][0]['type']) &&
                isset($res["registration"]) &&
                isset($res["registrationNormalized"]) &&
                isset($res['input'][0]["state"]["mileage"])
            ) {
                $response[] = [
                    'active' => $res['input'][0]['active'] ?? "ERROR",
                    'type' => $res['input'][0]['type'] ?? "ERROR",
                    'registration' => $res["registration"] ?? "ERROR",
                    'registrationNormalized' => $res["registrationNormalized"] ?? "ERROR",
                    'mileage_ts' => $res['input'][0]["state"]["mileage"]["ts"] ?? "ERROR",
                    'mileage_value' => $res['input'][0]["state"]["mileage"]["value"] ?? "ERROR",
                    'mileage_subtaskName' => $res['input'][0]["state"]["mileage"]["subtaskName"] ?? "ERROR",
                    'mileage_tsStateChange' => $res['input'][0]["state"]["mileage"]["tsStateChange"] ?? "ERROR",
                ];
            }
        }

        return $response;


//
//      $ch = curl_init();
//
//      curl_setopt($ch, CURLOPT_URL, $this->api . '/resources?fast=false');
//      curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
//      curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
//
//      $headers = array();
//      $headers[] = 'Accept: */*';
//      $headers[] = 'Authorization: Bearer '.$this->token;
//      curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
//
//      $result = curl_exec($ch);
//
//
//
//      if (curl_errno($ch)) {
//          echo 'Error:' . curl_error($ch);
//      }
//      curl_close($ch);
//      $result2 = json_decode($result, true);
//
//      //On ne concerve que les vehicle + active.
//      $resultsFiltered = collect($result2)->where('type','vehicle')->where('active',true)->toArray();
//      $response = [];
//
//
//      foreach($resultsFiltered as $res){
//
// dump($res);
//        if($res['input'][0]['active'] == true && $res['input'][0]['type'] == 'vehicle'){
//
//            if(
//               isset($res['input'][0]['active']) &&
//               isset($res['input'][0]['type']) &&
//               isset($res["registration"]) &&
//               isset($res["registrationNormalized"]) &&
//               isset($res['input'][0]["state"]["mileage"])  // pas toujours present.
//            ){
//               $response[] = [
//                  'active' => $res['input'][0]['active'] ?? "ERROR",
//                  'type' => $res['input'][0]['type'] ?? "ERROR",
//                  'registration' => $res["registration"] ?? "ERROR",
//                  'registrationNormalized' => $res["registrationNormalized"] ?? "ERROR",
//                  'mileage_ts' =>    $res['input'][0]["state"]["mileage"]["ts"] ?? "ERROR" ,
//                  'mileage_value' =>    $res['input'][0]["state"]["mileage"]["value"] ?? "ERROR" ,
//                  'mileage_subtaskName' =>    $res['input'][0]["state"]["mileage"]["subtaskName"] ?? "ERROR" ,
//                  'mileage_tsStateChange' =>    $res['input'][0]["state"]["mileage"]["tsStateChange"] ?? "ERROR" ,
//                      /*
//
//                         ['input'][0]["state"]["mileage"]
//                         [
//                            "ts" => "2024-07-01T08:47:55.000Z",
//                            "value" => 369102.515,
//                            "subtaskName" => "FMC640",
//                            "tsStateChange" => "2024-06-12T08:07:05.000Z",
//                          ]
//
//                        */
//                ];
//
//                } else {
//                 dump("Impossible a importer");
//                 dump($res);
//              }
//         }
//      }
//
//      return $response;


    }


}
