<?php

namespace App\Services;

use \Carbon\Carbon;
class ApiLogManager
{
    protected string $bearerToken;

    public function __construct(){
        // get token from .env:  API_LOG_TOKEN=mkIBMUUJRcEvAFfFZtldjjy9Zhb3O0c4x7PErr4Pf08936c8
        //You can generate a token via url : https://sup.eglobalpro.com/user/api-tokens
        //The generated token has no expiration date.

        $this->bearerToken = env('API_LOG_TOKEN');
    }


    public function api_post_method($args)
    {
        if(env('APP_ENV') === 'production') {
            $url = "https://sup.eglobalpro.com/api/add-log";
        } else {
            $url = "http://sup.eglobalpro.test/api/add-log";
        }

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        $authorization = "Authorization: Bearer " . $this->bearerToken;
        curl_setopt($ch, CURLOPT_HTTPHEADER, array($authorization));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_COOKIESESSION, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");

        $query = http_build_query($args);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $query);

        $result = curl_exec($ch);
        curl_close($ch);
        return $result;
    }


    public function log(
        string $type,   // 'import' pour l'instant
        string $soc,   // 'OMP','WEBFLEET',...
        string $started_at,
        string $finished_at,
        int $total_elements,
        int $total_time,
        array $data = []   //  converted to json, could be anything
    ){
        return $this->api_post_method([
            "type" => $type,
            "soc" => $soc,
            "started_at" => $started_at,
            "finished_at" => $finished_at,
            "total_elements" => $total_elements,
            "total_time" => $total_time,
            "data" => json_encode($data),
        ]);

    }
}
