<?php

namespace App\Models\ST\Parc\materiel;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Materiel_det extends Model
{
    const UPDATED_AT = 'sys_date_modification';
    const CREATED_AT = 'sys_date_creation';

    protected $guarded = ['*']; //'CONTREMARQUE','IMMAT','TYPE_ENTRETIEN','REFERENCE','DESCRIPTIF','QUANTITE','PRIX_UNITAIRE_HT','PRIX_UNITAIRE_HT_ETR1','PRIX_TOTAL_HT','PRIX_TOTAL_HT_ETR1','TX_TVA','CODE_ATELIER'
    protected$fillable = ['ID_MATERIEL_DET','IMMAT','PID_MATERIEL_ET','FIN','KM_FIN', 'SYS_USER_CREATION', 'SYS_USER_MODIFICATION','KM_DEBUT','SYS_DATE_CREATION', 'DEBUT'];
    protected $primaryKey = 'ID_MATERIEL_DET';
    public $incrementing = false;
    protected $keyType = 'string';
    public $table = 'materiel_det';
    use HasFactory;
    public function et()
    {
        return $this->belongsTo(Materiel_det::class, 'PID_MATERIEL_ET', 'ID_MATERIEL_ET');
    }
}