<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Http\Controllers\pluginsEgp\ArchivageCompta\ArchivageComptaController;

class ArchiveCompta implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $n_dossier;
    protected $n_exercice;
    protected $database;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($database,$n_dossier, $n_exercice )
    {
        $this->n_dossier = $n_dossier;
        $this->n_exercice = $n_exercice;
        $this->database = $database;
    }
    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        // dd('ici');
        // $n_dossier = $this->n_dossier;
        // $n_exercice = $this->n_exercice;
        // $database = $this->database;
        $archiveCompta = new ArchivageComptaController();
        $archiveCompta->index($this->database, $this->n_dossier, $this->n_exercice);
           }
}
