<?php

namespace App\Http\Middleware;

use Closure;

class RedirectIfProduction
{
    /**
     * Handle an incoming request.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if ('local' !== app()->environment()) {
            return abort(403, 'You are not authorized to access this');
        }

        if ('127.0.0.1' !== $request->ip()) {
            return abort(403, 'You are not authorized to access this');
        }

        return $next($request);
    }
}