<?php

namespace App\Http\Controllers\pluginsEgp\ArchivageCompta;

use App\Http\Controllers\Controller;
use App\Models\ST\auto\comptabilit_archive_det;
use App\Models\ST\auto\comptabilit_archive_et;
use App\Models\ST\auto\comptabilit_et;
use Illuminate\Http\Request;

class ArchivageComptaController extends Controller
{
    public function index( $database, $n_dossier, $n_exercice)
    {
        $et=comptabilit_et::on($database)->where('N_DOSSIER', $n_dossier)->where('N_EXERCICE', $n_exercice)->get();
        $i=0;
        // DD($et->det()->get());
        foreach ($et as $key => $value) {
            $newEt[$key] = $value->replicate();
            unset($newEt[$key]->SYS_DATE_CREATION);
            unset($newEt[$key]->SYS_DATE_MODIFICATION);

            $newEt[$key]= new comptabilit_archive_et();
            $newEt[$key]->setConnection($database);
            $newEt[$key]->fill($value->toArray());
            $newEt[$key]->ID_COMPTABILIT_ARCHIVE_ET = $value->ID_COMPTABILIT_ET;
            $newEt[$key]->COMMENTAIRE=mb_convert_encoding($newEt[$key]->COMMENTAIRE, 'UTF-8', 'UTF-8');
            $newEt[$key]->MEMO_BLOCAGE=mb_convert_encoding($newEt[$key]->MEMO_BLOCAGE, 'UTF-8', 'UTF-8');
            $newEt[$key]->HISTO=mb_convert_encoding($newEt[$key]->HISTO, 'UTF-8', 'UTF-8');
            $newEt[$key]->CORPS_MESSAGE_VALIDATION=mb_convert_encoding($newEt[$key]->CORPS_MESSAGE_VALIDATION, 'UTF-8', 'UTF-8');
            // $newEt[$key]->save();
            unset($dets);
            // $results=$newEt[$key]->save();
            $etInsert[$key]=$newEt[$key]->attributesToArray();
            $dets=$et[$key]->det()->get();
            unset($newEt[$key], $value);
            if(count($dets)>=1){
            foreach($dets as $key2 => $det){
                $newDet=$det->replicate();
                $newDet->setTable('comptabilit_archive_det');
                $newDet->setConnection($database);
                $newDet->ID_COMPTABILIT_ARCHIVE_DET = $det->ID_COMPTABILIT_DET;
                $newDet->PID_COMPTABILIT_ARCHIVE_ET = $det->PID_COMPTABILIT_ET;
                unset($newDet->PID_COMPTABILIT_ET, $newDet->FACTO_PAIEMENT, $newDet->BALANCE, $newDet->BALANCE_TVA,$newDet->DATE_DECLA_TVA,$newDet->TVA_OD_VENTIL_VTES_20, $newDet->TVA_OD_VENTIL_VTES_10,$newDet->TVA_OD_VENTIL_VTES_7, $newDet->TVA_OD_VENTIL_VTES_5,$newDet->TVA_OD_VENTIL_VTES_2, $newDet->TVA_OD_VENTIL_HA_20, $newDet->TVA_OD_VENTIL_HA_10, $newDet->TVA_OD_VENTIL_HA_7,  $newDet->TVA_OD_VENTIL_HA_5, $newDet->TVA_OD_VENTIL_HA_2,  $newDet->NOM_COMPTE_GENERAL, $newDet->LIEN_DOCUMENT_ARCHIVE_LISTE, $newDet->VALID, $newDet->IBAN, $newDet->SYS_DATE_CREATION,$newDet->SYS_DATE_MODIFICATION );
                $detInsert[$i]=$newDet->attributesToArray();
                $i=$i+1;
            }

        }
        }
        foreach (array_chunk($etInsert,500) as $t)  
        {
            comptabilit_archive_et::on($database)->insert($t);
        }
        foreach (array_chunk($detInsert,500) as $dt)  
        {
            comptabilit_archive_det::on($database)->insert($dt);
        } 
        return 'Started, check manually at Jobs table in Eglobalpro Database for the status of the job (if nothing, it is done, if not, contact support@eglobalpro.fr';
    }
    public function verifComptaArchive( $database, $n_dossier, $n_exercice){
        $et=comptabilit_et::on($database)->where('N_DOSSIER', $n_dossier)->where('N_EXERCICE', $n_exercice)->sum('DEBIT');
        $etArchive=comptabilit_archive_et::on($database)->where('N_DOSSIER', $n_dossier)->where('N_EXERCICE', $n_exercice)->sum('DEBIT');
        if($et==$etArchive){
            // comptabilit_et::on($database)->where('N_DOSSIER', $n_dossier)->where('N_EXERCICE', $n_exercice)->delete();
            return 'Good, Deleting'.$et.' etArchive: '.$etArchive;
        }
        else {
            return 'Something went wrong, check manually "\r\n" et: '.$et.' etArchive: '.$etArchive.'';
        }
    }
}
