<?php 
namespace App\Http\Controllers\OneShot;

use App\Http\Controllers\Controller;
use App\Models\ST\auto\tiers;
use App\Models\ST\auto\tiers_info_banque;
use App\Models\ST\auto\tiers_infos_salaries;
use GuzzleHttp\Psr7\Response;
use Illuminate\Http\Request;
class UpdateRh extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {   
        //recup datas from file
        $file = file_get_contents(storage_path('app/file/hotfix/update_pdl.txt'));
        $rows = explode("\n", $file);
        $data = [];
        $columns = explode("\t", $rows[0]);unset($rows[0]);//row by row
        foreach($rows as $row => $value){
            $fields = explode("\t", $value);
            $datas= array_combine($columns, $fields);
            $datas = mb_convert_encoding($datas,'UTF-8', 'UTF-8' );
            $results=tiers_infos_salaries::on('pdl')->where('N_SS', $datas['N_SS'])->first();
            if($results){
            $results->fill($datas);
            if(empty($results->DATE_SORTIE)){
                unset($results->DATE_SORTIE);
            }
            if(empty($results->DATE_AFFILIATION_MUTUELLE)){
                unset($results->DATE_AFFILIATION_MUTUELLE);
            }
            if(empty($results->N_PERSONNE_CHARGE)){
                unset($results->N_PERSONNE_CHARGE);
            }
            $results->save();
            $tiers=tiers::on('pdl')->where("ID_TIERS",$results->PID_TIERS)->first();
            if($tiers){
                $tiers->fill($datas);
                if(empty($tiers->CODE_POSTAL)){
                    unset($tiers->CODE_POSTAL);
                }
                $tiers->save();
            }
            $tiers_ib=tiers_info_banque::on('pdl')->where('PID_TIERS',$results->PID_TIERS)->first();
            if($tiers_ib){
            $tiers_ib->fill($datas);
            $tiers_ib->save();
        }
        };
    }
    }
}