<?php

/**
 * blablatest
 *
 * 
 */

namespace App\Http\Controllers\NewClientsCreation;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Hotfixs\HotfixsController;
use App\Models\ST\auto\aide_configuration_entreprise;
use App\Models\ST\auto\aide_exercice;
use App\Models\ST\auto\droit_usage;
use App\Models\ST\auto\tiers;
use App\Models\ST\auto\tiers_info_banque;
use App\Models\ST\auto\tiers_info_comptable;
use App\Models\ST\auto\tiers_infos_salaries;
use App\Models\ST\auto\tresorerie_compte;
use App\Models\ST\support\Support_et;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use Nette\Utils\Random;
use Illuminate\Support\Str;

/**
 * SqueletteController
 */
class SqueletteController extends Controller
{

    /**
     * configDb
     *
     * @param  mixed $request
     */
    public function configDb(request $request)
    {
        $newDb = $request->newDb;
        //CREATION DB
        // DB::statement("CREATE DATABASE IF NOT EXISTS $newDb");

        // CREATE TABLE THEN INSERT 
        $tablesName = DB::connection('coue')->select(DB::raw("select tab.table_name
        from information_schema.tables tab
        left join information_schema.columns col
                  on tab.table_schema = col.table_schema
                  and tab.table_name = col.table_name
                  and col.column_name LIKE '%DOSSIER%'
        where tab.table_schema not in ('information_schema', 'mysql',
                                   'performance_schema', 'sys')
              and tab.table_type = 'BASE TABLE'
              and col.column_name is null
              and tab.table_name LIKE 'aide%'
              and tab.table_schema like 'bdd_trs_coue'
        order by tab.table_schema,
                 tab.table_name;"));
        // Copie des tables de la base de données
        foreach ($tablesName as $table) {
            // DB::statement("DROP TABLE IF EXISTS $newDb.$table->table_name;");
            DB::statement("CREATE TABLE  $newDb.$table->table_name LIKE bdd_trs_coue.$table->table_name;");
            DB::statement("TRUNCATE TABLE $newDb.$table->table_name ;");
            DB::statement("INSERT INTO $newDb.$table->table_name SELECT * FROM bdd_trs_coue.$table->table_name;");
        }
    }
    /**
     * importDatasfromClients importe les données du nouveau client dans la base de données 
     * 
     * importe les données du nouveau client dans la base de données depuis les fichiers dans /STORAGE/APP/FILE
     * et log les résultats dans /STORAGE/LOGS/IMPORTSNEWCLIENTS
     *
     */
    public function importDatasfromClients($nomSimple)
    {
        file_put_contents(storage_path('logs/importsClients.log'), '');
        $path = storage_path('/app/file/newClient/');
        $files = scandir($path);
        foreach ($files as $file) {
            if ($file == '.' || $file == '..' || $file== 'configs'|| $file== 'FEC.txt') {
                continue;
            }
            $tableSimple = str_replace('.csv', '', $file);
            $table = "App\Models\ST\auto\\$tableSimple";
            DB::statement("DROP TABLE IF  EXISTS  bdd_trs_lanwest.$tableSimple;");
            DB::statement("CREATE TABLE IF NOT EXISTS  bdd_trs_lanwest.$tableSimple   LIKE bdd_trs_coue.$tableSimple;");
            // $csv = array_map('str_getcsv', file($path.$file), [';']);
            file_put_contents($path . $file, mb_convert_encoding(rtrim(file_get_contents($path . $file)), 'UTF-8', 'ISO-8859-1'));
            $file = fopen($path . $file, 'r');
            $csv = [];
            while (!feof($file)) {

                $repl = preg_replace('~(\d{2})/(\d{2})/(\d{2,4})~', '$3-$2-$1', fgetcsv($file, 0, ';'));
                // if($tableSimple==='tresorerie_compte'){
                //     print_r($repl);
                // }
                // dd($repl);
                array_push($csv, $repl);
            }
            fclose($file);
            // dd($datas);

            // dd($csv);
            array_walk($csv, function (&$a) use ($csv) {
                $a = array_combine($csv[0], $a);
            });
            array_shift($csv);
            # remove column header
            // dd($csv);
            foreach ($csv as $ligne) {
                $tableModel = new $table;
                $id = "ID_" . strtoupper($tableModel->getTable());
                $ligne[$id] = Random::generate(32);
                try {
                    $aide_confi_ets = $tableModel->fill(array_filter($ligne));
                    $tableModel->setConnection($nomSimple);
                    $tableModel->save();
                    // Log::channel('importsNewClient')->error($ligne);
                } catch (\Throwable $th) {
                    Log::channel('importsNewClient')->error($th->getMessage());
                }
            }
        }
    }
    /**
     * listDir
     * liste les fichiers du dossier storage/app/file
     *
     * @return array
     */
    public function listDir()
    {
        $liste = scandir(storage_path('/app/file/newClient/'));
        $liste = array_diff($liste, array('.', '..'));
        return $liste;
    }
    public function AddDocToImport(request $request){
        $path = $request->blabla->getRealPath();
        $logo = file_get_contents($path);
        $base64 = base64_encode($logo);
        $src = 'data: ' . mime_content_type($path) . ';base64,' . $base64;
        Storage::disk('local')->delete('file/newClient/' . $request->blabla->getClientOriginalName());
        Storage::disk('local')->put('file/newClient/' . $request->blabla->getClientOriginalName(), $logo);
    }
    /**
     * linkTiers
     * 
     * lie les tiers a ses dépendances
     * 
     * lie les tiers a ses dépendances : Tiers_infos_salarié, tiers_info_banque, tiers_info_compta
     * 
     * @todo : faire une fonction pour chaque dépendance
     *
     * @return void
     */
    public function linkTiers($nomSimple)
    {
        $tiersAll = tiers::on($nomSimple)->get();

        foreach ($tiersAll as $tiers) {
            if (!$tiers->RAISON_SOCIALE) {
                $tiers->RAISON_SOCIALE = trim($tiers->NOM) . ' ' . trim($tiers->PRENOM);
                $tiers->save();
            }
            

                //tiers_infos_salaries
                $tiersDet = tiers_infos_salaries::on($nomSimple)->where('NOM_SALARIE', $tiers->RAISON_SOCIALE)->first();
                if ($tiersDet) {
                    tiers_infos_salaries::on($nomSimple)->where('ID_TIERS_INFOS_SALARIES', $tiersDet->ID_TIERS_INFOS_SALARIES)->update(['PID_TIERS' => $tiers->ID_TIERS]);
                }
                //tiers_infos_banque
                $tiersDet = tiers_info_banque::on($nomSimple)->where('INTITULE_COMPTE', $tiers->RAISON_SOCIALE)->get();
                if ($tiersDet) {
                        tiers_info_banque::on($nomSimple)->where('INTITULE_COMPTE', $tiers->RAISON_SOCIALE)->update(['PID_TIERS' => $tiers->ID_TIERS]);
                }
                // //tiers_infos_compta
                $tiersDet = tiers_info_comptable::on($nomSimple)->where('NOM_CLIENT', $tiers->RAISON_SOCIALE)->get();
                if ($tiersDet) {
                        tiers_info_comptable::on($nomSimple)->where('NOM_CLIENT', $tiers->RAISON_SOCIALE)->update(['PID_TIERS' => $tiers->ID_TIERS]);
                }
            
            $tiers->CODE_CLIENT = strtoupper(substr(str_replace(' ', '', $tiers->RAISON_SOCIALE), 0, 10) . '/' . substr(str_replace(' ', '', $tiers->VILLE), 0, 10) . '/01');
            // dd(mb_convert_encoding($tiers->CODE_CLIENT, 'UTF-8','ISO-8859-1'));
            tiers::on('lanwest')->where('ID_TIERS', $tiers->ID_TIERS)->update(['CODE_CLIENT' => mb_convert_encoding($tiers->CODE_CLIENT, 'UTF-8','UTF-8')]);
            // $tiers->save();R
        //     if (strlen(str_replace(' ', '', $tiers->TEL1_FR)) < 10) {
        //         $tiers->TEL1_FR = '0' . $tiers->TEL1_FR;
        //         $tiers->save();
        //     }
        //     if (strlen(str_replace(' ', '', $tiers->TEL_PORTABLE_FR)) < 10) {
        //         $tiers->TEL_PORTABLE_FR = '0' . $tiers->TEL_PORTABLE_FR;
        //         $tiers->save();
        //     }
        //     if (strlen(str_replace(' ', '', $tiers->FAX_FR)) < 10) {
        //         $tiers->FAX_FR = '0' . $tiers->FAX_FR;
        //         $tiers->save();
        //     }
        }
        $doublons = DB::connection($nomSimple)->select("select * from tiers where CODE_CLIENT in (
            select CODE_CLIENT from tiers group by CODE_CLIENT having count(*) > 1) ORDER BY CODE_CLIENT ASC");
        // dd($doublons);
        if (count($doublons) > 1) {
            foreach ($doublons as $doublon) {
                Log::channel('importsNewClient')->error('doublons CODE_CLIENTS =' . $doublon->CODE_CLIENT);
            }
            //Add details to materiel
            // $addMaterielDet = new HotfixsController;
            // $addMaterielDet->AddMaterielDet($nomSimple);
        }
        // return 'yay';
    }
    public function linkDossiers($nomSimple)
    {
        $aide_config_all = aide_configuration_entreprise::on($nomSimple)->get();
        foreach ($aide_config_all as $aide_config) {
            //tresorerie_compte
            $treso_compte = tresorerie_compte::on($nomSimple)->where('N_DOSSIER', $aide_config->N_DOSSIER)->get();
            // dd($treso_compte);
            if ($treso_compte) {
                foreach ($treso_compte as $treso) {
                    $treso->PID_AIDE_CONFIGURATION_ENTREPRISE = $aide_config->ID_AIDE_CONFIGURATION_ENTREPRISE;
                    $treso->save();
                }
                //aide_exercice
                $aide_exercice = aide_exercice::on($nomSimple)->where('N_DOSSIER',  $aide_config->N_DOSSIER)->get();
                if ($aide_exercice) {
                    foreach ($aide_exercice as $aide) {
                        $aide->PID_AIDE_CONFIGURATION_ENTREPRISE = $aide_config->ID_AIDE_CONFIGURATION_ENTREPRISE;
                        $aide->save();
                    }
                }

                //droit_usage
                $droits_usage = droit_usage::on($nomSimple)->where('N_DOSSIER', $aide_config->N_DOSSIER)->get();
                if ($droits_usage) {
                    foreach ($droits_usage as $droit) {
                        $droit->PID_AIDE_CONFIGURATION_ENTREPRISE = $aide_config->ID_AIDE_CONFIGURATION_ENTREPRISE;
                        $droit->save();
                    }
                }
            }
        }
    }
    public function creationTiersInfoCompta($nomSimple)
    {
        $tiers = tiers::on($nomSimple)->get();
        foreach ($tiers as $tier) {
            // dd($tiers);
            $dossiers = explode(';', $tier->NOM_DOSSIER);
            foreach ($dossiers as $dossier) {
                $n_dossier = DB::connection($nomSimple)->table('aide_configuration_entreprise')->select('N_DOSSIER')->where('RAISON_SOCIALE', $dossier)->first();
                $nom_treso = DB::connection($nomSimple)->table('tresorerie_compte')->select('NOM')->where('N_TRESO', 1)->where('N_DOSSIER', $n_dossier->N_DOSSIER)->first(); //Jointure sur tresorerie_compte
                $codesTiers = explode(';', $tier->CODE_TIERS);
                foreach ($codesTiers as $code) {
                    // dd($code);
                    switch ($code) {
                        case ('Salari'):
                            $tiers_infos_compta_cli = tiers_info_comptable::on('coue')->where('CODE_JOURNAL', 'VTES')->first();
                            $tiers_infos_compta_frs = tiers_info_comptable::on('coue')->where('CODE_JOURNAL', 'HA')->first();

                            $tiers_infos_compta_cli->PID_TIERS = $tier->ID_TIERS;
                            $tiers_infos_compta_cli->NOM_CLIENT = $tier->RAISON_SOCIALE;
                            $tiers_infos_compta_cli->NOM_DOSSIER = $dossier;
                            $tiers_infos_compta_cli->N_DOSSIER = $n_dossier->N_DOSSIER;
                            $tiers_infos_compta_cli->N_TRESO = 1;
                            $tiers_infos_compta_cli->N_TYPE_RGT = 3;
                            $tiers_infos_compta_cli->N_DELAI_RGT = 1;
                            $tiers_infos_compta_cli->NOM_DELAI_RGT = 'Comptant';
                            $tiers_infos_compta_cli->NOM_TAXE_PAIEMENT  = 'Comptant';
                            $tiers_infos_compta_cli->N_CPTE_BILAN = "42100000";
                            $tiers_infos_compta_cli->CODE_JOURNAL = 'OD';
                            $tiers_infos_compta_cli->NOM_JOURNAL = 'Oprations diverses';
                            $tiers_infos_compta_cli->NOM_TRESO = $nom_treso->NOM;
                            $tiers_infos_compta_cli->ID_TIERS_INFO_COMPTABLE = Random::generate(32);
                            unset($tiers_infos_compta_cli->CONCAT_LIGNE_TVA, $tiers_infos_compta_cli->N_CPTE_RESULTAT, $tiers_infos_compta_cli->N_CPTE_TVA, $tiers_infos_compta_cli->ICG, $tiers_infos_compta_cli->CLT, $tiers_infos_compta_cli->SYS_DATE_CREATION, $tiers_infos_compta_cli->SYS_DATE_MODIFICATION, $tiers_infos_compta_cli->VENTILATION, $tiers_infos_compta_cli->N_TAXE_PAIEMENT, $tiers_infos_compta_cli->NOM_TAXE_PAIEMENT);
                            $test = new tiers_info_comptable;
                            $test->setConnection($nomSimple);
                            $test->fill($tiers_infos_compta_cli->getAttributes());
                            $test->save();

                            // $tiers_infos_compta_frs->PID_TIERS=$tier->ID_TIERS;
                            // $tiers_infos_compta_frs->NOM_CLIENT=$tier->RAISON_SOCIALE;
                            // $tiers_infos_compta_frs->NOM_DOSSIER=$dossier;
                            // $tiers_infos_compta_frs->N_DOSSIER=$n_dossier->N_DOSSIER;
                            // $tiers_infos_compta_frs->N_TRESO=1;
                            // $tiers_infos_compta_frs->N_TYPE_RGT=3;
                            // $tiers_infos_compta_frs->N_DELAI_RGT=1;
                            // $tiers_infos_compta_frs->NOM_DELAI_RGT ='Comptant';
                            // $tiers_infos_compta_frs->NOM_TAXE_PAIEMENT  ='Comptant';
                            // $tiers_infos_compta_frs->N_CPTE_BILAN="42100000";
                            // $tiers_infos_compta_frs->CODE_JOURNAL='OD';
                            // $tiers_infos_compta_frs->NOM_JOURNAL='Opérations diverses';
                            // $tiers_infos_compta_frs->NOM_TRESO =$nom_treso->NOM;
                            // $tiers_infos_compta_frs->ID_TIERS_INFO_COMPTABLE=Random::generate(32);
                            // unset($tiers_infos_compta_frs->CONCAT_LIGNE_TVA, $tiers_infos_compta_frs->N_CPTE_RESULTAT, $tiers_infos_compta_frs->N_CPTE_TVA, $tiers_infos_compta_frs->ICG,$tiers_infos_compta_frs->CLT,$tiers_infos_compta_frs->SYS_DATE_CREATION,$tiers_infos_compta_frs->SYS_DATE_MODIFICATION,$tiers_infos_compta_frs->VENTILATION,$tiers_infos_compta_frs->N_TAXE_PAIEMENT,$tiers_infos_compta_frs->NOM_TAXE_PAIEMENT);
                            // $test= new tiers_info_comptable;
                            // $test->setConnection($nomSimple);
                            // $test->fill($tiers_infos_compta_frs->getAttributes());
                            // $test->save();

                            break;
                        case ('Client'):
                            $tiers_infos_compta_cli = tiers_info_comptable::on('coue')->where('CODE_JOURNAL', 'VTES')->first();

                            // dd($tiers_infos_compta_cli);
                            $tiers_infos_compta_cli->PID_TIERS = $tier->ID_TIERS;
                            $tiers_infos_compta_cli->NOM_CLIENT = $tier->RAISON_SOCIALE;
                            $tiers_infos_compta_cli->NOM_DOSSIER = $dossier;
                            $tiers_infos_compta_cli->N_DOSSIER = $n_dossier->N_DOSSIER;
                            $tiers_infos_compta_cli->N_TRESO = 1;
                            $tiers_infos_compta_cli->NOM_TRESO = $nom_treso->NOM;
                            $tiers_infos_compta_cli->N_TYPE_RGT = 3;
                            $tiers_infos_compta_cli->N_DELAI_RGT = 2;
                            $tiers_infos_compta_cli->ID_TIERS_INFO_COMPTABLE = Random::generate(32);
                            unset($tiers_infos_compta_cli->CONCAT_LIGNE_TVA, $tiers_infos_compta_cli->N_CPTE_RESULTAT, $tiers_infos_compta_cli->N_CPTE_TVA, $tiers_infos_compta_cli->ICG, $tiers_infos_compta_cli->CLT, $tiers_infos_compta_cli->SYS_DATE_CREATION, $tiers_infos_compta_cli->SYS_DATE_MODIFICATION, $tiers_infos_compta_cli->VENTILATION, $tiers_infos_compta_cli->N_TAXE_PAIEMENT);
                            $test = new tiers_info_comptable;
                            $test->setConnection($nomSimple);
                            $test->fill($tiers_infos_compta_cli->getAttributes());

                            // dd($test);
                            $test->save();

                            // dd($tiers_infos_compta_cli);
                            break;
                        case ('Fournisseur'):
                            $tiers_infos_compta_frs = tiers_info_comptable::on('coue')->where('CODE_JOURNAL', 'HA')->first();

                            $tiers_infos_compta_frs->PID_TIERS = $tier->ID_TIERS;
                            $tiers_infos_compta_frs->NOM_CLIENT = $tier->RAISON_SOCIALE;
                            $tiers_infos_compta_frs->NOM_DOSSIER = $dossier;
                            $tiers_infos_compta_frs->N_DOSSIER = $n_dossier->N_DOSSIER;
                            $tiers_infos_compta_frs->N_TRESO = 1;
                            $tiers_infos_compta_frs->NOM_TRESO = $nom_treso->NOM;
                            $tiers_infos_compta_frs->N_TYPE_RGT = 3;
                            $tiers_infos_compta_frs->N_DELAI_RGT = 2;
                            $tiers_infos_compta_frs->ID_TIERS_INFO_COMPTABLE = Random::generate(32);
                            unset($tiers_infos_compta_frs->CONCAT_LIGNE_TVA, $tiers_infos_compta_frs->N_CPTE_RESULTAT, $tiers_infos_compta_frs->N_CPTE_TVA, $tiers_infos_compta_frs->ICG, $tiers_infos_compta_frs->CLT, $tiers_infos_compta_frs->SYS_DATE_CREATION, $tiers_infos_compta_frs->SYS_DATE_MODIFICATION, $tiers_infos_compta_frs->VENTILATION, $tiers_infos_compta_frs->N_TAXE_PAIEMENT);
                            $test = new tiers_info_comptable;
                            $test->setConnection($nomSimple);
                            $test->fill($tiers_infos_compta_frs->getAttributes());
                            $test->save();
                            break;
                        default:
                            break;
                    }
                }
            }
        }
    }
    public function showLog()
    {
        $all = file_get_contents(storage_path('logs/importsClients.log'));
        $all = explode("\n", $all);
        array_map('utf8_encode', $all);
        return $all;
    }
    public function saveConfig(request $request)
    {
        $config= $request->config;
        $name= $request->name;
        Storage::disk('local')->put("file/newClient/configs/$name.json", json_encode($config));
        // dd($config);
    }
    public function getConfigs(request $request)
    {
        $path = storage_path('app/file/newClient/configs/');
        $liste = scandir($path);
        $liste = array_diff($liste, array('.', '..'));
        return $liste;
        // dd($config);
    }
}
