<?php

namespace App\Http\Controllers\InterfacesApi\numeria;

use App\Http\Controllers\Controller;
use App\Mail\alertRefusSign;
use App\Models\ST\auto\document_signature;
use App\Models\ST\auto\tiers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;


class StatusAll extends Controller
{
  public function MajStatusAll($db)
  {
    $toUpdate = document_signature::on($db)->where('DOCUUID_NUMERIA', '<>', '')->where('STATUS', '<>', '300')->where('STATUS', '<>', '400')->pluck('DOCUUID_NUMERIA');
    // dd($toUpdate);
    foreach ($toUpdate
      as $key => $value) {
      $envoi = new StatusAll();
      $rep = json_decode($envoi::DoCurl($value));
      $code = $rep[0]->statusCode;

      $UUID = $rep[0]->docUUID;
      switch ($rep[0]->statusCode) {
        case 101:
          $infos = 'En attente du destinataire';
          break;
        case 000:
          $infos = 'Envoi en cours';
          break;
        case 400:
          $infos = $rep[0]->statusInfo;
          // $pid = document_signature::on($db)->select('PID_TIERS')->where('DOCUUID_NUMERIA', $UUID)->first();
          // $client = tiers::on($db)->where('ID_TIERS', $pid)->first();
          // Mail::to('contact.vayres@colocauto.com')->send(new alertRefusSign($client));
          break;
        default:
          $infos = $rep[0]->statusInfo;
          break;
      }
      // $infos = $rep[0]->statusInfo;
      DB::connection($db)->select(DB::raw("update document_signature set STATUS = '$code', STATUSINFO='$infos' where DOCUUID_NUMERIA = '$UUID'"));
      // $final[$value]=json_decode($response)[0]->statusCode;
    }
  }
  static function DoCurl($value)
  {
    $curl = curl_init();
    curl_setopt_array($curl, array(
      CURLOPT_URL => env('NUMERIABASEURL') . 'documentsStatus',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS => json_encode([
        'login' => env('NUMERIALOGIN'),
        'password' => env('NUMERIAPASSWORD'),
        'documents' => [$value],
      ]),
      CURLOPT_HTTPHEADER => array(
        'Content-Type: application/json'
      ),
    ));
    $response = curl_exec($curl);
    return $response;
  }
}
