<?php

namespace App\Http\Controllers\InterfacesApi\S3P;

use App\Http\Controllers\Controller;
use App\Services\ApiLogManager;
use App\Services\S3P\S3pApiWrapper;
use App\Models\ST\Parc\materiel\Materiel_det;
use App\Models\ST\Parc\materiel\Materiel_et;
use Illuminate\Support\Carbon;
use Illuminate\Support\Str;



class S3pImportKms extends Controller
{
    public function s3pImportKms()
    {
        $started_at = now()->format('Y-m-d H:i:s');
        ob_start();
        $start=microtime(true);

        // Instanciation du wrapper S3pApiWrapper
        $serviceAPI = new S3pApiWrapper();

        // Récupération des ressources à importer
        $datas = $serviceAPI->getRessources();

        // Format de données attendu : voir commentaires
        foreach ($datas as $data) {
            // Recherche du matériel étiqueté correspondant au numéro d'immatriculation
            $et = Materiel_et::on('pdl')
                ->where('IMMATRICULATION', trim($data["registration"]))
                ->first();

            if ($et != null && isset($data["mileage_value"])) {
                // Récupération du km_fin_max et de la date_fin_max pour l'étiquette
                $km_fin_max = $et->det->max('KM_FIN');
                $date_fin_max = $et->det->max('FIN');

                if($km_fin_max == null ){
                    $km_fin_max = $data["mileage_value"];
                    $date_fin_max = date('Y-m-d');
                }

                if ($km_fin_max < $data["mileage_value"]) {
                    // Création d'un nouveau matériel détaillé si le km_fin_max est inférieur au km valeur de l'import
                    Materiel_det::on('pdl')
                        ->create([
                            'ID_MATERIEL_DET' => Str::random(32),
                            'IMMAT' => trim($data["registration"]),
                            'PID_MATERIEL_ET' => $et->ID_MATERIEL_ET,
                            'FIN' => Carbon::parse($data["mileage_ts"])->format('Y-m-d'),
                            'KM_FIN' => $data["mileage_value"],
                            'KM_DEBUT' => $km_fin_max,
                            'SYS_USER_CREATION' => 'IMPORT_S3P',
                            'SYS_USER_MODIFICATION' => 'IMPORT_S3P',
                            'DEBUT' => $date_fin_max,
                        ]);
                    /* Pour controller si import ok*/
                    dump([
                        'ID_MATERIEL_DET' => Str::random(32),
                        'IMMAT' => trim($data["registration"]),
                        'PID_MATERIEL_ET' => $et->ID_MATERIEL_ET,
                        'FIN' => Carbon::parse($data["mileage_ts"])->format('Y-m-d'),
                        'KM_FIN' => $data["mileage_value"],
                        'KM_DEBUT' => $km_fin_max,
                        'SYS_USER_CREATION' => 'IMPORT_S3P',
                        'SYS_USER_MODIFICATION' => 'IMPORT_S3P',
                        'DEBUT' => $date_fin_max,
                    ]);
                }
            }
        }


        $end=microtime(true);
        $phpinfo=ob_get_contents();
        ob_end_clean();
        $time=$end-$start;

        $finished_at = now()->format('Y-m-d H:i:s');
        (new ApiLogManager())
            ->log(
                "import",
                "S3P",
                $started_at,
                $finished_at,
                count($datas),
                $time,
                [],
            );


        // Retour d'une chaîne de caractères indiquant que l'import est terminé
        return 'Done';



//        /*
//        $serviceAPI = new S3pApiWrapper();
//
//
////        $dbs= \App\Http\Controllers\Utils\MultiDbController::getListeDbsXXXXX();
//
//        $datas = $serviceAPI->getRessources();
//        /* Format de data :
//            [
//                  'active'
//                  'type'
//                  'registration'
//                  'registrationNormalized'
//                  'mileage_ts'
//                  'mileage_value'
//                  'mileage_subtaskName'
//                  'mileage_tsStateChange'
//             ]
//
//             */
//
//        foreach ($datas as $data) {
//            $et = Materiel_et::on('pdl')
//                ->where('IMMATRICULATION', trim($data["registrationNormalized"]))
//                ->first();
//
//
//
//            if ($et && isset($data["mileage_value"])) :
//                $km_fin_max = $et->det->max('KM_FIN');
//                $date_fin_max = $et->det->max('FIN');
//                if ($km_fin_max < $data["mileage_value"]) :
//
//                    Materiel_det::on('pdl')
//                        ->create(
//                            [
//                                'ID_MATERIEL_DET' => Str::random(32),
//                                'IMMAT' => trim($data["registrationNormalized"]),
//                                'PID_MATERIEL_ET' => $et->ID_MATERIEL_ET,
//                                'FIN' => Carbon::parse($data["mileage_ts"])->format('Y-m-d'),
//                                'KM_FIN' => ($data["mileage_value"]),
//                                'KM_DEBUT' => $km_fin_max,
//                                'SYS_USER_CREATION' => 'IMPORT_S3P',
//                                'SYS_USER_MODIFICATION' => 'IMPORT_S3P',
//                                'DEBUT' => $date_fin_max
//                            ]
//                        );
//                endif;
//            endif;
//        };
//        return 'Done';
//        */
    }
}
