<?php

namespace App\Http\Controllers\InterfacesApi\OMP\Imports;

use App\Http\Controllers\Controller;
use App\Http\Controllers\InterfacesApi\OMP\OmpIdent;
use App\Http\Controllers\Utils\MultiDbController;
use App\Models\ST\Parc\materiel\Materiel_det;
use App\Models\ST\Parc\materiel\Materiel_et;
use App\Services\ApiLogManager;
use Illuminate\Support\Str;

class OmpImportKms extends Controller
{

    public function OmpImportKmsExe(){


        $dbs=MultiDbController::getListeDbsOmp();
        $dbs=['trm'];
        $datas=json_decode($this->GetKmsOmp());


        array_map(function($db) use ($datas){

            $total_imported_for_db = 0;
            $started_at = now()->format('Y-m-d H:i:s');
            ob_start();
            $start=microtime(true);


            foreach($datas as $data){
                // On recherche la plaque
                $et=Materiel_et::on($db)
                    ->where('IMMATRICULATION',$data->immatriculation)
                    ->first();
                dump($et);
                if($et && isset($data->dernierKm))  : $km_fin_max=$et->det->max('KM_FIN');
                    $date_debut=$et->det->max('FIN');

                    if($km_fin_max<$data->dernierKm) :
                        Materiel_det::on($db)
                            ->create([
                                'ID_MATERIEL_DET' => Str::random(32),
                                'IMMAT' => $et->IMMATRICULATION,
                                'PID_MATERIEL_ET' => $et->ID_MATERIEL_ET,
                                'FIN' => date('Y-m-d'),
                                'KM_FIN' => $data->dernierKm,
                                'SYS_USER_CREATION' => 'IMPORT_OMP',
                                'SYS_USER_MODIFICATION' => 'IMPORT_OMP',
                                'KM_DEBUT'=> $km_fin_max,
                                'DEBUT'=>$date_debut
                            ]);
                        $total_imported_for_db++;
                    endif;
                endif;
            }

            // timer end + Log $total_importde_for_db
            $end=microtime(true);
            $phpinfo=ob_get_contents();
            ob_end_clean();
            $time=$end-$start;

            $finished_at = now()->format('Y-m-d H:i:s');
            (new ApiLogManager())
                ->log(
                    "import",
                    "OMP-".strtoupper($db),
                    $started_at,
                    $finished_at,
                    $total_imported_for_db,
                    $time,
                    [],
                );
            dd([
                "import",
                "OMP-".strtoupper($db),
                $started_at,
                $finished_at,
                $total_imported_for_db,
                $time,
                [],]);


        },$dbs);


        dd();
        return $datas;
    }


//    public function OmpImportKmsExe()
//    {
//        $started_at = now()->format('Y-m-d H:i:s');
//        ob_start();
//        $start=microtime(true);
//
//        // Récupération de la liste des bases de données
//        $dbs = MultiDbController::getListeDbsOmp();
//
//        // Récupération des données à importer (en JSON)
//        $datas = $this->GetKmsOmp();
//        $datas = json_decode($datas);
//
//        // Traitement des données pour chaque db
//        array_map(function ($data) use ($dbs) {
//            foreach ($dbs as $db) {
//                // Recherche du matériel correspondant au numéro d'immatriculation
//                $et = Materiel_et::on($db)
//                    ->where('IMMATRICULATION', $data->immatriculation)
//                    ->first();
//
//                if ($et && isset($data->dernierKm)) {
//                    // Récupération du km_fin_max et de la date_debut
//                    $km_fin_max = $et->det->max('KM_FIN'); /* peut etre null */
//                    $date_debut = $et->det->max('FIN'); /* peut etr null */
//
//
//                    if (count($et->det) > 0) {
//                        // Cas où il y a déjà des enregistrements de détails , null < null => false
//                        if ($km_fin_max < $data->dernierKm) {
//                            // Création d'un nouveau matériel détaillé si le km_fin_max est inférieur au km valeur de l'import
//                            $inserted = Materiel_det::on($db)
//                                ->create([
//                                    'ID_MATERIEL_DET' => Str::random(32),
//                                    'IMMAT' => $et->IMMATRICULATION,
//                                    'PID_MATERIEL_ET' => $et->ID_MATERIEL_ET,
//                                    'FIN' => date('Y-m-d'),
//                                    'KM_FIN' => $data->dernierKm ?? 0,
//                                    'SYS_USER_CREATION' => 'IMPORT_OMP',
//                                    'SYS_USER_MODIFICATION' => 'IMPORT_OMP',
//                                    'KM_DEBUT' => $km_fin_max ?? 0,
//                                    'DEBUT' => $date_debut,
//                                ]);
//                        }
//                    } else {
//                        // Cas où il n'y a pas encore d'enregistrements de détails
//                        // Création du premier enregistrement Materiel_det
//                        Materiel_det::on($db)
//                            ->create([
//                                'ID_MATERIEL_DET' => Str::random(32),
//                                'IMMAT' => $et->IMMATRICULATION,
//                                'PID_MATERIEL_ET' => $et->ID_MATERIEL_ET,
//                                'FIN' => date('Y-m-d'),
//                                'KM_FIN' => $data->dernierKm ?? 0,
//                                'SYS_USER_CREATION' => 'IMPORT_OMP',
//                                'SYS_USER_MODIFICATION' => 'IMPORT_OMP',
//                                'KM_DEBUT' => $data->dernierKm ?? 0,
//                                'DEBUT' => date('Y-m-d'),
//                            ]);
//                    }
//                }
//            }
//        }, $datas);
//
//        $end=microtime(true);
//        $phpinfo=ob_get_contents();
//        ob_end_clean();
//        $time=$end-$start;
//
//        $finished_at = now()->format('Y-m-d H:i:s');
//        (new ApiLogManager())
//            ->log(
//                "import",
//                "OMP",
//                $started_at,
//                $finished_at,
//                count($datas),
//                $time,
//                [],
//            );
//
//        // Retour des données traitées
//        return $datas;
//    }


    public function OmpImportKmsExepjp(){
        $started_at = now()->format('Y-m-d H:i:s');
        ob_start();
        $start=microtime(true);

        $datas=$this->GetKmsOmppjp();
        $datas=json_decode($datas);
            foreach($datas as $data){
                $et=Materiel_et::on('pjp')->where('IMMATRICULATION',$data->immatriculation)->first();
                if($et && isset($data->dernierKm))  : $km_fin_max=$et->det->max('KM_FIN');
                $date_debut=$et->det->max('FIN');

                if($km_fin_max == null ){
                    $km_fin_max = $data->dernierKm;
                    $date_debut = date('Y-m-d');
                }

                if($km_fin_max<=$data->dernierKm) :
                $inserted = Materiel_det::on('pjp')->create(['ID_MATERIEL_DET' => Str::random(32), 'IMMAT' => $et->IMMATRICULATION, 'PID_MATERIEL_ET' => $et->ID_MATERIEL_ET, 'FIN' => date('Y-m-d'), 'KM_FIN' => $data->dernierKm, 'SYS_USER_CREATION' => 'IMPORT_OMP', 'SYS_USER_MODIFICATION' => 'IMPORT_OMP','KM_DEBUT'=> $km_fin_max, 'DEBUT'=>$date_debut]);
                endif;
                endif;
            }

        $end=microtime(true);
        $phpinfo=ob_get_contents();
        ob_end_clean();
        $time=$end-$start;

        $finished_at = now()->format('Y-m-d H:i:s');
        (new ApiLogManager())
            ->log(
                "import",
                "OMP-PJP",
                $started_at,
                $finished_at,
                count($datas),
                $time,
                [],
            );

        return $datas;
    }

    static function GetKmsOmp(){
        $curl = curl_init();
        $access_token = OmpIdent::GetToken();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'http://portail-omp.coue-trm.fr/service-rh-parc/api/moteurs/lister',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
              'Authorization: Bearer '.$access_token,
            ),
          ));
          $response = curl_exec($curl);
          curl_close($curl);
          return $response;
    }

    static function GetKmsOmppjp(){
        $curl = curl_init();
        $access_token = OmpIdent::GetTokenpjp();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://omp-portail.sogranlotrans.fr:9443/service-rh-parc/api/moteurs/lister',
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => 2,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
              'Authorization: Bearer '.$access_token,
            ),
          ));
          $response = curl_exec($curl);
          curl_close($curl);
          return $response;
    }
}
