<?php

namespace App\Http\Controllers\ImportsClients;

use App\Http\Controllers\Controller;
use App\Models\ST\Parc\materiel\Materiel_det;
use App\Models\ST\Parc\materiel\Materiel_et;
use App\Services\ApiLogManager;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Http;

class ImportDispatch extends Controller
{
    public function importDispatch(Request $request, $database)
    {
        $log = "";
        $all = $request->all();
        foreach ($all as $key => $ligne) {
            $det = Materiel_det::on($database)->where('IMMAT', '=', $ligne['ImmatVehicule'])->orderBy('KM_FIN', 'desc')->get();

            /* Après un appel GET on peut obtenir une collection vide */
            if(count($det) != 0){
                if ($det[0]->KM_FIN >= $ligne['KMSCompteur']) {
                    $log .= 'Immatriculation ' . $ligne['ImmatVehicule'] . ' non trouvée dans la base de données. ';
                    Log::channel('slackAlert')->emergency('Import failed here : ' . __FILE__ . ' by the user import_omp');
                } else {
                    $test = Materiel_det::on($database)->create(['ID_MATERIEL_DET' => Str::random(32), 'IMMAT' => $ligne['ImmatVehicule'], 'PID_MATERIEL_ET' => $det[0]->PID_MATERIEL_ET, 'FIN' => $ligne['DateDonneesUTC'], 'KM_FIN' => $ligne['KMSCompteur'], 'SYS_USER_CREATION' => 'IMPORT_OMP', 'SYS_USER_MODIFICATION' => 'IMPORT_OMP','KM_DEBUT'=> $det[0]->KM_FIN, 'DEBUT'=>$det[0]->FIN]);
                    $log .= 'Immatriculation ' . $ligne['ImmatVehicule'] . ' trouvée dans la base de données. ';
                }
            }

        }
        return $log;
    }
    public function importDispatchTransics()
    {
        $started_at = now()->format('Y-m-d H:i:s');
        ob_start();
        $start=microtime(true);


        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://txtangob.tx-connect.com/IWS_ASMX/Service.asmx?WSDL',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => '<?xml version="1.0" encoding="utf-16"?>
    <soap:Envelope xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema">
        <soap:Body>
            <Get_Vehicles_V13 xmlns="http://transics.org">
                <Login>
                    <DateTime>0001-01-01T00:00:00</DateTime>
                    <Version>0</Version>
                    <Dispatcher>EGLOBALPRO</Dispatcher>
                    <Password>EGLOBALPRO_10198102193</Password>
                    <SystemNr>2193</SystemNr>
                    <ApplicationName />
                    <ApplicationVersion />
                    <PcName />
                    <Integrator>EGLOBALPRO</Integrator>
                    <Language>en</Language>
                </Login>
                <VehicleSelection>
                    <Identifiers />
                    <IncludePosition xsi:nil="true" />
                    <IncludeActivity xsi:nil="true" />
                    <IncludeDrivers xsi:nil="true" />
                    <IncludeObcInfo xsi:nil="true" />
                    <IncludeETAInfo xsi:nil="true" />
                    <IncludeTemperatureInfo xsi:nil="true" />
                    <IncludeInfoFields xsi:nil="true" />
                    <IncludeUpdateDates xsi:nil="true" />
                    <IncludeInactive xsi:nil="true" />
                    <IncludeLastTextMessageInboxOutbox xsi:nil="true" />
                    <IncludeLastAlarmMessage xsi:nil="true" />
                    <IncludeBlockedVehicleInfo xsi:nil="true" />
                    <IncludeCompanyCardInfo xsi:nil="true" />
                    <IncludeVehicleProfile xsi:nil="true" />
                    <IncludeNextStopInfo xsi:nil="true" />
                    <DiagnosticFilter />
                    <IncludeExtraTruckInfo xsi:nil="true" />
                    <IncludeGroups xsi:nil="true" />
                    <IncludeRented xsi:nil="true" />
                    <IncludePlanningInfo xsi:nil="true" />
                </VehicleSelection>
            </Get_Vehicles_V13>
        </soap:Body>
    </soap:Envelope>',
            CURLOPT_HTTPHEADER => array(
                'Content-Type: text/xml'
            ),
        ));
        $response = curl_exec($curl);

        curl_close($curl);

        // return $response;

        $response = strtr($response, ['</soap:' => '</', '<soap:' => '<']);
        $output = json_decode(json_encode(simplexml_load_string($response)));
        $xml = simplexml_load_string($response, "SimpleXMLElement", LIBXML_NOCDATA);
        $json = json_encode($xml);
        $array = json_decode($json, TRUE);
        $vehs = $array['Body']['Get_Vehicles_V13Response']['Get_Vehicles_V13Result']['Vehicles']['InterfaceVehicleResult_V13'];
        // $results=$output->Body->Get_Vehicles_V13Response->Get_Vehicles_V13Result->Vehicles->InterfaceVehicleResult_V13;

        // $i=0;
        foreach ($vehs as $veh) {
            $det=Materiel_det::on('morin')->where('IMMAT',$veh['LicensePlate'])->orderBy('KM_FIN','DESC')->get();
            if(count($det)>1){
            $test = Materiel_det::on('morin')->create(['ID_MATERIEL_DET' => Str::random(32), 'IMMAT' => $veh['LicensePlate'], 'PID_MATERIEL_ET' => $det[0]->PID_MATERIEL_ET, 'FIN' => $veh['Modified'], 'KM_FIN' => $veh['CurrentKms'], 'SYS_USER_CREATION' => 'IMPORT_TRANSICS', 'SYS_USER_MODIFICATION' => 'IMPORT_TRANSICS', 'DEBUT' => $det[0]->DATE_FIN, 'KM_DEBUT' => $det[0]->KM_FIN]);
            }
        }

        $end=microtime(true);
        $phpinfo=ob_get_contents();
        ob_end_clean();
        $time=$end-$start;

        $finished_at = now()->format('Y-m-d H:i:s');
        (new ApiLogManager())
            ->log(
                "import",
                "TRANSICS",
                $started_at,
                $finished_at,
                count($vehs),
                $time,
                [],
            );

    }
}
