<?php
/**
 * Exports for external clients 
 */

namespace App\Http\Controllers\ExportsClients;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Utils\SelectClient;
use App\Models\ST\Commande_et;
use App\Models\ST\Comptabilit_det;
use App\Models\ST\ges_co\HA\FACT\Ges_co_document_achat_fact_et;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

/**
 * Check asked database and table, then export datas
 */
class ExportDispatch extends Controller
{    
    /**
     * exportDispatch
     * 
     * export datas from a simple table passed as param
     * 
     * Check db right, then get the table, then get the datas
     *
     * @param  mixed $request
     * @param  mixed $database
     * @param  mixed $table
     * @param  mixed $n_dossier
     * @param  mixed $n_ex
     * @return array $datas
     */
    public function exportDispatch(Request $request, $database, $table, $n_dossier, $n_ex)
    {
        Log::channel('ApiCalledByExterne')->info('L\'endpoint '.$request->path().' a appel� par un client externe.');
        ini_set('memory_limit', '2G');
        if(!SelectClient::GetSelect($table)){
            abort(response('You are authentificated, but asked the wrong table.', 404));
        }
        $select = SelectClient::GetSelect($table);
        $fields = $select[0];
        $datas = DB::connection($database)
            ->table($select[1])
            ->select(DB::raw($fields))
            ->when(strpos($select[0], 'N_DOSSIER'), function ($q) use ($n_dossier, $n_ex) {
                return $q->where('N_DOSSIER', '=', $n_dossier);
            })
            ->when(strpos($select[0], 'N_EXERCICE'), function ($q) use ($n_dossier, $n_ex) {
                return $q->where('N_EXERCICE', '=', $n_ex);
            })
            ->when(strpos($select[0], 'TYPE_OR'), function ($q) {
                return $q->where('TYPE_OR', '!=', '');
            })
            ->get();
        return ($datas);
    }

        
    /**
     * exportDispatchEtDet
     *
     * export datas from a table with a relation with another table
     * 
     * Check db right, then get the table, then get the datas, then get linked datas
     * @param  mixed $request
     * @param  mixed $database
     * @param  mixed $table
     * @param  mixed $n_dossier
     * @param  mixed $n_ex
     * @return Json $datas
     */
    public function exportDispatchEtDet(Request $request, $database, $table, $n_dossier, $n_ex)
    {
        Log::channel('ApiCalledByExterne')->info('L\'endpoint '.$request->path().' a été appelé par un client externe: '.$request->headers->get('referer'));
        ini_set('memory_limit', '2G');
        if(!SelectClient::GetSelect($table)){
            abort(response('You are authentificated, but asked the wrong table.', 404));
        }
        $select = SelectClient::GetSelect($table);
        try {
            $all = $select['modl']::on($database)
            ->with('det')
            ->when(strpos($select['et'], 'N_DOSSIER'), function ($q) use ($n_dossier, $n_ex) {
                return $q->where('N_DOSSIER', '=', $n_dossier);
            })
            ->when(strpos($select['et'], 'N_EXERCICE'), function ($q) use ($n_dossier, $n_ex) {
                return $q->where('N_EXERCICE', '=', $n_ex);
            })
            ->get(); // WORKING TO GET ALL 
        } catch (Exception $e) {
            echo $e->getMessage();exit;
        }
        
        $alls = $all->toArray();
        // dd($all);
        foreach ($alls as $key => $ligne) {
            foreach ($ligne as $namechamp => $datachamps) {
                if (!strpos($select['et'], $namechamp)) {
                    if ($namechamp !== 'det') {
                        unset($alls[$key][$namechamp]);
                    } else {
                        // echo ();
                        if (count($datachamps) >= 1) {
                            foreach ($datachamps as $nomchampdet => $datadet) {
                                foreach ($datadet as $nomder => $datadets) {
                                    if (!strpos($select['det'], $nomder)) {
                                        unset($alls[$key][$namechamp][$nomchampdet][$nomder]);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            // dd($ligne);
        }
        return ($alls);
    }

        
    /**
     * exportDispatchRh
     * 
     * export datas from a table human ressources related
     * 
     * @todo Deal with RGPD and other security issues
     *
     * @param  mixed $database
     * @param  mixed $table
     * @param  mixed $n_dossier
     * @param  mixed $n_ex
     * @return Json $datas
     */
    public function exportDispatchRh(Request $request,$database, $table, $n_dossier, $n_ex)
    {

        Log::channel('ApiCalledByExterne')->info('L\'endpoint '.$request->path().' a été appelé par un client externe: '.$request->headers->get('referer'));
        ini_set('memory_limit', '2G');
        $select = SelectClient::GetSelectRh($table, $database);
        $fields = $select[0];
        $datas = DB::connection($database)
            ->table($select[1])
            ->select(DB::raw($fields))
            ->when(strpos($select[0], 'N_DOSSIER'), function ($q) use ($n_dossier) {
                return $q->where('N_DOSSIER', '=', $n_dossier);
            })
            ->when(strpos($select[0], 'N_EXERCICE'), function ($q) use ($n_ex) {
                return $q->where('N_EXERCICE', '=', $n_ex);
            })
            ->get();
            if($database==='pdl' && $table==='tiers_infos_salaries'
            ){
                foreach ($datas as $item) {
                    $names=explode(' ', $item->NOM_SALARIE);
                    // dd($names);
                    $item->NOM= isset($names[0]) ? $names[0] : 'Vide';
                    $item->PRENOM= isset($names[1]) ? $names[1] : 'Vide';
                }
            }
        return ($datas);
    }

        
    
}
