<?php

namespace App\Console\Commands;

use App\Http\Controllers\InterfacesApi\OMP\OmpIdent;
use App\Http\Controllers\Utils\MultiDbController;
use App\Models\ST\Parc\materiel\Materiel_det;
use App\Models\ST\Parc\materiel\Materiel_et;
use App\Services\ApiLogManager;
use Illuminate\Console\Command;
use Illuminate\Support\Str;

class OmpImportKmsCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'import:omp';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Importation OMP des Kms pour toutes les bases.';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->output->title('Starting OMP import');
        $this->output->note("use api_log_token : " . env('API_LOG_TOKEN'));

        $dbs = MultiDbController::getListeDbsOmp();
        $datas = json_decode($this->GetKmsOmp());
        $this->output->note("total datas : " . count($datas));

        array_map(function ($db) use ($datas) {
            $this->output->info("- use db " . $db);

            $total_imported_for_db = 0;
            $started_at = now()->format('Y-m-d H:i:s');
            ob_start();
            $start = microtime(true);


            foreach ($datas as $data) {
                // On recherche la plaque
                $et = Materiel_et::on($db)
                    ->where('IMMATRICULATION', $data->immatriculation)
                    ->first();

                if ($et && isset($data->dernierKm))  : $km_fin_max = $et->det->max('KM_FIN');
                    $date_debut = $et->det->max('FIN');

                    if ($km_fin_max < $data->dernierKm) :
                        Materiel_det::on($db)
                            ->create([
                                'ID_MATERIEL_DET' => Str::random(32),
                                'IMMAT' => $et->IMMATRICULATION,
                                'PID_MATERIEL_ET' => $et->ID_MATERIEL_ET,
                                'FIN' => date('Y-m-d'),
                                'KM_FIN' => $data->dernierKm,
                                'SYS_USER_CREATION' => 'IMPORT_OMP',
                                'SYS_USER_MODIFICATION' => 'IMPORT_OMP',
                                'KM_DEBUT' => $km_fin_max,
                                'DEBUT' => $date_debut
                            ]);
                        $total_imported_for_db++;
                        $this->output->note( $et->IMMATRICULATION . " " . $km_fin_max . "km => " . $data->dernierKm."km");

                    endif;
                endif;
            }

            // timer end + Log $total_importde_for_db
            $end = microtime(true);
            $phpinfo = ob_get_contents();
            ob_end_clean();
            $time = $end - $start;
            $finished_at = now()->format('Y-m-d H:i:s');
            if($total_imported_for_db != 0){
                $result = (new ApiLogManager())
                    ->log(
                        "import",
                        "OMP-" . strtoupper($db),
                        $started_at,
                        $finished_at,
                        $total_imported_for_db,
                        $time,
                        [],
                    );
                dump($result);
            } else {
                $this->output->warning("no record updated!");
                $result = (new ApiLogManager())
                    ->log(
                        "warning",
                        "OMP-" . strtoupper($db),
                        $started_at,
                        $finished_at,
                        $total_imported_for_db,
                        $time,
                        [
                            "tested"=> count($datas),
                            "db"=> $db,
                        ],
                    );
                dump($result);
            }

            $this->output->newLine();
        }, $dbs);

        $this->output->success("Import terminé.");

        /*
         * PJP SECTION
         */
        $this->output->title('Import OMP-PJP');
        $started_at = now()->format('Y-m-d H:i:s');
        ob_start();
        $start = microtime(true);
        $inserted = 0;

        $datas = $this->GetKmsOmppjp();
        $datas = json_decode($datas);

        $this->output->note("total datas : " . count($datas));
        foreach ($datas as $data) {
            $et = Materiel_et::on('pjp')->where('IMMATRICULATION', $data->immatriculation)->first();
            if ($et && isset($data->dernierKm))  : $km_fin_max = $et->det->max('KM_FIN');
                $date_debut = $et->det->max('FIN');

                if ($km_fin_max == null) {
                    $km_fin_max = $data->dernierKm;
                    $date_debut = date('Y-m-d');
                }

                if ($km_fin_max <= $data->dernierKm) :
                    $inserted++;
                    Materiel_det::on('pjp')->create(['ID_MATERIEL_DET' => Str::random(32), 'IMMAT' => $et->IMMATRICULATION, 'PID_MATERIEL_ET' => $et->ID_MATERIEL_ET, 'FIN' => date('Y-m-d'), 'KM_FIN' => $data->dernierKm, 'SYS_USER_CREATION' => 'IMPORT_OMP', 'SYS_USER_MODIFICATION' => 'IMPORT_OMP', 'KM_DEBUT' => $km_fin_max, 'DEBUT' => $date_debut]);
                endif;
            endif;
        }

        $end = microtime(true);
        $phpinfo = ob_get_contents();
        ob_end_clean();
        $time = $end - $start;

        $finished_at = now()->format('Y-m-d H:i:s');
        if($inserted != 0){
            $result = (new ApiLogManager())
                ->log(
                    "import",
                    "OMP-PJP",
                    $started_at,
                    $finished_at,
                    $inserted,
                    $time,
                    [],
                );

            dump($result);
        } else {
            $this->output->warning("no record updated!");
            $result = (new ApiLogManager())
                ->log(
                    "warning",
                    "OMP-PJP",
                    $started_at,
                    $finished_at,
                    $inserted,
                    $time,
                    [
                        "tested"=> count($datas),
                        "db"=> "pjp",
                    ],
                );

            dump($result);
        }

        $this->output->newLine();
        $this->output->success("Import terminé.");
        return Command::SUCCESS;
    }

    static function GetKmsOmp()
    {
        $curl = curl_init();
        $access_token = OmpIdent::GetToken();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'http://portail-omp.coue-trm.fr/service-rh-parc/api/moteurs/lister',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'Authorization: Bearer ' . $access_token,
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        return $response;
    }

    static function GetKmsOmppjp()
    {
        $curl = curl_init();
        $access_token = OmpIdent::GetTokenpjp();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://omp-portail.sogranlotrans.fr:9443/service-rh-parc/api/moteurs/lister',
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => 2,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'Authorization: Bearer ' . $access_token,
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        return $response;
    }
}
